#pragma once

#ifndef DLLMANAGER_H
#define DLLMANAGER_H
/////////////////////////////////////////////////////////////////////////////
#include "Cmd.h"
#include "Service.h"
#include "Config.h"
#include <afxtempl.h>
#include "CATMessage.h"
#include "Option.h"
/////////////////////////////////////////////////////////////////////////////
#ifdef COMMON_EXPORTS
	#define COMMON_API __declspec(dllexport)
#else
	#define COMMON_API __declspec(dllimport)
#endif
/////////////////////////////////////////////////////////////////////////////
#define		kResponseDefaultValue	-1
#define		kDelayDefaultValue		0
#define		kResponseKey			"Response"
#define		kDelayKey				"Delay"
#define		kPrefFile				"Pref"
#define		kConfigFile				"Config"
#define		kConfigExt				"vpc"
// Define Layer name use to set dependencies, carrefull, have to be same as return by CLink::GetIdentification()
#define		kETSI0710MUXIdentification	"ETSI 07.10 Mux"
#define		kPMUXIdentification			"PalmSource Mux"
/////////////////////////////////////////////////////////////////////////////
// use when append msg in VP to display icon
enum eIconType
{
	eIconInfo=0,
	eIconError,
	eIconWarning
};
/////////////////////////////////////////////////////////////////////////////
const int WU_THREAD_TERMINATED = WM_APP + 1;
const int WU_THREAD_START   = WM_APP + 2;
/////////////////////////////////////////////////////////////////////////////
class CService;
/////////////////////////////////////////////////////////////////////////////
class COMMON_API CDllManager
{
protected:	 
	// Member variables
	CMapWordToOb*			mMapSvcP;			// ServiceID->Service Object
	StructAT*				mTabAllP;
	int						mTabAllLength;	
	CList<int,int>			mNotAllowedList;	// cmd id that don't have to be executed
	CWnd*					mMainVPFrameP;
	UINT					mATReplyMsgID;
	UINT					mVPMsgID;
	CFileDB					*mFile, *mConfigFile;
	COption*				mOption;
	CMapWordToOb			mMapFwdData;		// ChannelID -> ptr to the service in charge to process the data (ServceSMS or serviceDATA)

	CService*				mServToFwToP;
	int						mDataChannel;
	CCriticalSection		mCriticalSec, mCriticalSec2;
	// specify if each config will save or not params in their ~
	Bool					mSaveOnExit;	
	Bool					mConfigHasChanged;

	// DllGenerator specific
	CMapStringToString		mMapBasedService;	// ServiceID->ServiceName
	CMapStringToString		mMapConfigName;		// ConfigID->configName
	CMapWordToOb*			mMapCfgP;			// ConfigID->ptrConfig

	// Implementation
	virtual StructAT*		Fusion();
	void					AddService(WORD iKey, CObject* iObjectP);
	void					AddConfig(WORD iKey, CObject* iObjectP);
	virtual void			InitService()=0;
	virtual void			LoadAdditionalParam();	
	
	// Mux state
	int						mMuxStatus;

public:	
	CDllManager(void);	
	virtual ~CDllManager(void);
	virtual CString			GetIdentification()=0;
	virtual CString			GetLinkDependency() {return "";}; // Return Description of requiered link
	
	// Common API
	virtual void			AppendVPMsg(char* iMsgP, int iIconID=-1);
	virtual void			SendATMsg(char* iMsgP, UInt8 iChannel=(UInt8)-1, UInt32 iCount=(UInt32)-1, Bool iForced=FALSE);
	virtual void			Init(CWnd* iMainVPFrameP, UINT iATMsgID, UINT iVPMsgID);
	virtual Bool			Dispatch(CCmd* iCmdP, Bool* ioDataModeP);
	virtual Bool			ForwardData(CDataMessage* ioDataP);
	virtual Bool			IsChannelAvailable(UInt8 iChannel);	
	virtual void			UpdateUI();
	// call save function on each config
	virtual Bool			SaveConfigState();
	virtual void			LoadConfig(Bool iBroadcast=FALSE);

	// Accessors
	virtual StructAT*		GetCmdTable();
	virtual int				GetCmdTableLength();	
	virtual StructAT*		GetCmdStruct(CString iCmdName);
	virtual INT_PTR			GetNbConfig();
	virtual INT_PTR			GetNbService();
	virtual CConfig*		GetConfigByIndex(INT_PTR iIndex);
	virtual BOOL			GetConfigName(int iConfigID, CString &ioName);		
	virtual CConfig*		GetConfig(WORD iKey);
	virtual CMapWordToOb*	GetCfgMap();
	virtual CService*		GetService(WORD iKey);
	virtual CMapWordToOb*	GetSvcMap();
	virtual void			AddNotAllowedCmd(int iUniqueCmdID);
	virtual void			RemoveNotAllowedCmd(int iUniqueCmdID);
	virtual Bool			IsAllowed(int iUniqueCmdID);
	virtual UInt8			GetCREG()=0;
	virtual int				GetCPIN()=0;
	virtual UInt8			GetCFUN()=0;
	virtual UInt8			GetCMEE()=0;
	virtual UInt8			GetPhonePower()=0;
	virtual void			SetPhonePower(UInt8 iPower)=0;
	virtual UInt8			GetPhoneFunctionality()=0;
	virtual void			SetPhoneFunctionality(UInt8 iFun)=0;
	virtual UInt8			GetNwkRegistration()=0;
	virtual void			SetNwkRegistration(UInt8 iState)=0;
	virtual void			SetPhoneInReadyState()=0;
	virtual void			SetPhoneInPIN1State()=0;
	virtual void			SetPhoneInPIN2State()=0;
	virtual void			SetPhoneInPUK1State()=0;
	virtual void			SetPhoneInPUK2State()=0;
	virtual Bool			IsSIMInserted()=0;
	virtual CFileDB*		GetConfigFile() {return CFileUtil::GetFileUtil()->GetMainConfigFile();};	
	virtual CWnd*			GetVPFrame();
	virtual Bool			SaveOnExit() {return mSaveOnExit;};
	virtual void			SaveOnExit(Bool iState) {mSaveOnExit=iState;};
	virtual void			DeleteConfigFile();
	virtual void			SetOption(COption* iOption) {mOption=iOption;};
	virtual COption*		GetOption() {return mOption;};
	virtual Bool			ConfigHasChanged() {return mConfigHasChanged;};
	virtual void			ConfigHasChanged(Bool iChange) {mConfigHasChanged=iChange;};
	virtual int				GetMuxStatus() {return mMuxStatus;};

	// Vib
	virtual void			SendVib();

	// Com
	virtual void			SetMuxStatus(UInt8 iStatus){};
	virtual void			SetComMuxStatus(UInt8 iStatus);

	// Dll Generator interface
	BOOL					GetConfig(WORD iKey, CObject*& ioObject);
	virtual CMapStringToString* GetBasedServiceMap();
	virtual CMapStringToString* GetConfigNameMap();
	virtual void			AddBasedService(int iServiceID, CString iName);
	virtual void			AddConfigName(int iConfigID, CString iName);
	virtual BOOL			GetBasedServiceName(int iServiceID, CString &ioName);
	virtual int				GetBasedServiceID(CString iName);
};
#endif
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////

